<?php
/**
 * MyCitySelector
 * @author  Konstantin Kutsevalov
 * @version 2.0.0
 */

defined('_JEXEC') or die(header('HTTP/1.0 403 Forbidden') . 'Restricted access');

use joomx\mcs\plugin\helpers\McsData;

class MycityselectorModelProvinces extends Joomla\CMS\MVC\Model\ListModel
{

	/**
	 * Table name
	 * @var string
	 */
	private $table = '#__mycityselector_provinces';
    private $tableNames = '#__mycityselector_province_names';
    private $tableCountries = '#__mycityselector_countries';
    private $tableCountryNames = '#__mycityselector_country_names';


	/**
	 * For Input object link
	 * @var null
	 */
	private $input = null;

	public $_forms;

	/**
	 * Init
	 */
	function __construct($config = [])
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = ['ordering', 'id', 'name', 'subdomain', 'published', 'country'];
		}
		parent::__construct($config);
		$this->input = Joomla\CMS\Factory::getApplication()->input;
	}


	/**
	 * @return JDatabaseQuery
	 */
	protected function getListQuery()
	{
        $langId = McsData::getLangId();

		$db    = $this->getDbo();
		$query = $this->_db->getQuery(true);
		$query->select('prov.id AS id, provname.name AS name, prov.subdomain AS subdomain, prov.published AS published, prov.ordering AS ordering, cntname.name AS country')
			->from("`{$this->table}` AS prov")
            ->innerJoin("`{$this->tableNames}` AS `provname` ON `prov`.`id` = `provname`.`province_id`")
            ->where("`provname`.`lang_id` = {$langId}");

		// Filter by search in title or note or id:.
		$search = $this->getState('filter.search');
		if ( !empty($search) ) {
			if (stripos($search, 'id:') === 0) {
				$query->where($db->quoteName('id') . ' = ' . (int) substr($search, 3));
			}  else {
				$search = $db->quote('%' . strtolower($search) . '%');
				$query->where('(LOWER(c.name) LIKE ' . $search . ')');
			}
		}
		// Filter by country
		$country = $this->getState('filter.country');
		if ( !empty($country) ) {
			$query->where('prov.country_id = ' . $db->escape($country));
		}
		$query->innerJoin("`{$this->tableCountries}` AS cnt ON prov.country_id = cnt.id")
              ->innerJoin("`{$this->tableCountryNames}` AS `cntname` ON `cntname`.`country_id` = `prov`.`country_id`")
              ->where("`cntname`.`lang_id` = {$langId}");
		$query->order($db->qn($db->escape($this->getState('list.ordering', 'name'))) . ' ' . $db->escape($this->getState('list.direction', 'ASC')));

        // var_dump( str_replace('#__', $db->getPrefix(), $query->__toString()) ); exit;

		return $query;
	}


	protected function populateState($ordering = 'ordering', $direction = 'ASC')
	{
		parent::populateState($ordering, $direction); // TODO: Change the autogenerated stub
	}

}